<?xml version="1.0" encoding="GB2312"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html"/>
	<xsl:output indent="yes"/>
	<xsl:output encoding="GB2312"/>
	<xsl:template match="/">
		<html>
			<!-- ͷļ -->
			<HEAD>
				<TITLE>TRS WCM 5 ĵбҳ</TITLE>
				<META http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
				<LINK href="viewer/images/style.css" type="text/css" rel="stylesheet"/>
				<LINK href="viewer/images/rightclickmenu.css" type="text/css" rel="stylesheet"/>
			</HEAD>
			<BODY oncontextmenu="return false;" style="MARGIN: 5px">
				<!-- == TABLE1 == -->
				<TABLE class="list_table" height="100%" cellSpacing="1" cellPadding="0" width="100%" border="0">
					<TBODY>
						<!-- ROW1 ҳ̨ͷ-->
						<TR>
							<TD class="head_td" height="26">
								<TABLE height="26" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TBODY>
										<TR>
											<TD width="24">
												<IMG height="24" src="viewer/images/bite-blue-open.gif" width="24"/>
											</TD>
											<TD>Ƶĵб</TD>
											<TD/>
										</TR>
									</TBODY>
								</TABLE>
							</TD>
						</TR>
						<!--  END ROW1 ҳ̨ͷ-->
						<!-- ROW3 -->
						<TR>
							<TD vAlign="top">
								<!--~== TABLE3 ==~-->
								<!--~ TABLE3 ~-->
								<TABLE height="100%" cellSpacing="0" cellPadding="2" width="100%" bgColor="#ffffff" border="0">
									<TBODY>
										<!-- ROW10 -->
										<TR>
											<TD vAlign="top" align="left" height="20">
												<!--~== TABLE9 ==~-->
												<TABLE class="list_table" cellSpacing="1" cellPadding="0" width="100%" border="0">
													<TBODY>
														<!-- ROW11 ̨ͷ -->
														<TR class="list_th" bgColor="#EFEFEF" MenuIndex="1">
															<TD width="30" height="20"></TD>
															<TD></TD>
															<TD bgColor="#EFEFEF">ĵ</TD>
															<TD bgColor="#EFEFEF">ʱ</TD>
															<TD bgColor="#EFEFEF"></TD>
															<TD bgColor="#EFEFEF">Ŀ</TD>
															<TD bgColor="#EFEFEF">״̬</TD>
														</TR>
														<!--~ END ROW11 ̨ͷ~-->
														<!-- ѭÿƪ -->
														<xsl:apply-templates select="/WCMDOCUMENTS/WCMDOCUMENT"/>
														<!-- END ѭÿƪ -->
													</TBODY>
												</TABLE>
												<!--~ END TABLE9 ~-->
											</TD>
										</TR>
										<!--~ END ROW10 ~-->
									</TBODY>
								</TABLE>
								<!--~ END TABLE3 ~-->
							</TD>
						</TR>
						<!--~- END ROW3 -~-->
					</TBODY>
				</TABLE>
				<!-- END TABLE1 -->
			</BODY>
		</html>
	</xsl:template>
	<xsl:template match="WCMDOCUMENTS/WCMDOCUMENT">
		<xsl:variable name="WCMRESFILE" select="document('resource.xml')"/>
		<xsl:variable name="WCMREFFILE" select="document('reference.xml')"/>
		<TR class="list_tr">
			<TD align="center">
				<xsl:number/>
			</TD>
			<TD align="middle" width="30" nowrap="nowrap">
				<xsl:variable name="DOCTYPENO" select="PROPERTIES/DOCTYPE"/>
				<xsl:variable name="DOCTYPEICON">
					<xsl:call-template name="cf_getDocTypeIcon">
						<xsl:with-param name="docTypeNo" select="$DOCTYPENO"/>
						<xsl:with-param name="resDoc" select="$WCMREFFILE"/>
					</xsl:call-template>
				</xsl:variable>
				<IMG src="{$DOCTYPEICON}" border="0"/>
			</TD>
			<TD width="*">
				<A href="trs_wcm_viewer_doview.htm?DocId={PROPERTIES/DOCID}" target="_blank" title="{PROPERTIES/DOCTITLE}">
					<xsl:variable name="TITLE" select="PROPERTIES/DOCTITLE"/>

					<xsl:call-template name="cf_getReadyText">
						<xsl:with-param name="title" select="$TITLE"/>
						<xsl:with-param name="maxLength" select="40"/>
					</xsl:call-template>
				</A>
			</TD>
			<TD align="middle"  width="100" nowrap="nowrap">
				<xsl:variable name="RAWTIME" select="PROPERTIES/CRTIME"/>
				<xsl:variable name="TIMEAFTER" select="substring-before(substring-after($RAWTIME, ':'), ':')"/>
				<xsl:if test="string-length($TIMEAFTER) != 0">
					<xsl:variable name="TIMEBEFORE" select="substring-before($RAWTIME, ':')"/>
					<xsl:value-of select="concat($TIMEBEFORE, ':', $TIMEAFTER)"/>
				</xsl:if>
			</TD>
			<TD align="middle" width="100" nowrap="nowrap">
				<xsl:value-of select="PROPERTIES/CRUSER"/>
			</TD>
			<xsl:variable name="DOCCHANNEL" select="PROPERTIES/DOCCHANNEL"/>
			<xsl:variable name="RAWCHNNAME">						
				<xsl:for-each select="$WCMRESFILE/RESOURCE/WCMCHANNELS/WCMCHANNEL/PROPERTIES[CHANNELID=$DOCCHANNEL]">
					<xsl:value-of select="CHNLDESC"/>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="READYCHNNAME">					
				<xsl:call-template name="cf_getReadyText">
					<xsl:with-param name="title" select="$RAWCHNNAME"/>
					<xsl:with-param name="maxLength" select="30"/>
				</xsl:call-template>
			</xsl:variable>
			<TD align="middle" width="120" nowrap="nowrap">			
				<SPAN title="{$RAWCHNNAME}" ><xsl:value-of select="$READYCHNNAME"/></SPAN>
			</TD>
			<TD align="middle" width="50" nowrap="nowrap">
				<xsl:variable name="DOCSTATUS" select="PROPERTIES/DOCSTATUS"/>
				<xsl:for-each select="$WCMRESFILE/RESOURCE/WCMSTATUSS/WCMSTATUS/PROPERTIES[STATUSID=$DOCSTATUS]">
					<xsl:value-of select="SDISP"/>
				</xsl:for-each>
			</TD>
		</TR>
	</xsl:template>
	<xsl:template name="cf_getDocTypeIcon">
		<xsl:param name="docTypeNo"/>
		<xsl:param name="resDoc"/>
		<xsl:variable name="RESULT" select="$resDoc/REFERENCE /WCMDOCTYPES/WCMDOCTYPE[DOCTYPEID=$docTypeNo]/ICONPATH"/>
		<xsl:variable name="DEFAULT" select="$resDoc/REFERENCE /WCMDOCTYPES/WCMDOCTYPE[DOCTYPEID=-1]/ICONPATH"/>
		<xsl:value-of select="$RESULT"/>
		<xsl:if test="not($RESULT)">
			<xsl:value-of select="$DEFAULT"/>
		</xsl:if>
		<!--
		<xsl:choose>
			<xsl:when test="$docTypeNo=10">
				<xsl:value-of select="string('viewer/images/document_text.gif')"/>
			</xsl:when>
			<xsl:when test="$docTypeNo=20">
				<xsl:value-of select="string('viewer/images/document_html.gif')"/>
			</xsl:when>
			<xsl:when test="$docTypeNo=30">
				<xsl:value-of select="string('viewer/images/document_link.gif')"/>
			</xsl:when>
			<xsl:when test="$docTypeNo=40">
				<xsl:value-of select="string('viewer/images/document_file.gif')"/>
			</xsl:when>
			<xsl:otherwise>viewer/images/document_text.gif</xsl:otherwise>
		</xsl:choose>
		-->
	</xsl:template>

	<xsl:template name="cf_getReadyText">
		<xsl:param name="title"/>
		<xsl:param name="maxLength"/>

		<xsl:if test="($maxLength - string-length($title)) >= 0">
			<xsl:value-of select="$title" disable-output-escaping="no"/>
		</xsl:if>
		<xsl:if test="string-length($title) > $maxLength">
			<xsl:value-of select="concat(substring($title, 1, $maxLength), '...')" disable-output-escaping="no"
/>
		</xsl:if>		
	</xsl:template>
</xsl:transform>
